<?php

namespace App\Http\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\Instagram;
use App\Models\InstagramFeeds;
use Illuminate\Support\Str;

class InstagramController extends Controller
{
    public function index()
    {
        $bc = ['title' => 'Pengaturan', 'subtitle' => 'Instagram'];
        return view('admin.pengaturan.instagram', compact('bc'));
    }

    public function handle(Request $req)
    {
        if (Instagram::find($req->state)->to_access_token) {
            $this->refresh_feed($req->state);
            Alert::toast('Sudah Terhubung Dengan Instagram', 'success');
            return redirect()->route('pengaturan.instagram');
        } else {
            if (!$req->has('code')) {
                Alert::toast('Gagal Mendapatkan Access Code', 'error');
                return redirect()->route('pengaturan.instagram');
            }

            $response = Http::accept('application/json')->asForm()->post('https://api.instagram.com/oauth/access_token', [
                'client_id' => env('INSTAGRAM_CLIENT_ID'),
                'client_secret' => env('INSTAGRAM_CLIENT_SECRET'),
                'grant_type' => 'authorization_code',
                'redirect_uri' => env('INSTAGRAM_REDIRECT_URI'),
                'code' => $req->code
            ]);

            if ($response->failed()) {
                Alert::toast('Gagal Mendapatkan Access Token', 'error');
                return redirect()->route('pengaturan.instagram');
            }

            $shortLivedToken = $response->json()['access_token'];
            $userId = $response->json()['user_id'];

            try {
                $long = $this->tukar_token($shortLivedToken);
                $profil = Instagram::find($req->state);
                $profil->to_access_token()->create([
                    'user_id' => $userId,
                    'access_token' => $long['access_token'],
                    'token_type' => $long['token_type'],
                    'expires_in' => $long['expires_in']
                ]);
                $this->refresh_feed($req->state);
                Alert::toast('Berhasil Terhubung Dengan Instagram', 'success');
                return redirect()->route('pengaturan.instagram');
            } catch (\Throwable $th) {
                Alert::toast('Gagal Terhubung Dengan Instagram', 'error');
                return redirect()->route('pengaturan.instagram');
            }
        }
    }

    public function tukar_token($token)
    {
        $response = Http::accept('application/json')->get('https://graph.instagram.com/access_token', [
            'grant_type' => 'ig_exchange_token',
            'client_secret' => env('INSTAGRAM_CLIENT_SECRET'),
            'access_token' => $token,
        ]);

        return $response->json();
    }

    public function ambil_media($token)
    {
        $response = Http::accept('application/json')->get('https://graph.instagram.com/v21.0/me/media', [
            'fields' => 'caption,id,media_type,media_url,thumbnail_url,permalink,children{media_type,media_url},timestamp',
            'access_token' => $token,
        ]);

        return $response->json();
    }

    public function refresh_feed($id)
    {
        $profil = Instagram::find($id);
        $accessToken = $profil->to_access_token->access_token;
        $media = $this->ambil_media($accessToken);
        $data = collect($media['data']);
        $nextUrl = $media['paging']['next'] ?? null;
        $this->store_feed($data, $profil);
        while ($nextUrl) {
            $next = $this->fetch_paging($nextUrl);
            $nextData = collect($next['data']);
            $nextUrl = $next['paging']['next'] ?? null;
            $this->store_feed($nextData, $profil);
        }
    }

    public function store_feed($data, $profil)
    {
        $data->map(function ($item) use ($profil) {
            // if (!empty($item['caption']) && Str::contains($item['caption'], ['stunting'])) {
            $profil->to_media()->updateOrCreate(['media_id' => $item['id']], [
                'media_id' => $item['id'],
                'media_type' => $item['media_type'],
                'media_url' => $item['media_url'],
                'caption' => $item['caption'] ?? null,
                'thumbnail_url' => $item['thumbnail_url'] ?? null,
                'permalink' => $item['permalink'],
                'children' => !empty($item['children']) ? $item['children']['data'] : null,
                'timestamp' => $item['timestamp']
            ]);
            // }
        });
    }

    public function fetch_paging($url)
    {
        $response = Http::accept('application/json')->get($url);
        return $response->json();
    }

    public function get_detail_post(Request $req)
    {
        try {
            $data = InstagramFeeds::with('to_profile')->where('media_id', $req->id)->first();
            if ($data) {
                return response()->json([
                    'message' => 'success',
                    'result' => $data
                ], 200);
            } else {
                return response()->json([
                    'message' => 'error',
                    'result' => ''
                ], 404);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'message' => $th->getMessage(),
                'result' => ''
            ], 500);
        }
    }
}
