<?php

namespace App\Http\Controllers;

use App\Http\Requests\Halaman;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Halaman as AM;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;
use RealRashid\SweetAlert\Facades\Alert;

class HalamanController extends Controller
{
    //
    public function index()
    {
        $bc = ['title' => 'Halaman', 'subtitle' => 'Semua Halaman'];
        $data = AM::orderBy('id')->paginate(10);
        $sampah = AM::onlyTrashed()->count();
        return view('admin.halaman.index', compact('bc', 'data', 'sampah'));
    }

    public function create()
    {
        $bc = ['title' => 'Halaman', 'subtitle' => 'Buat Halaman'];
        return view('admin.halaman.baru', compact('bc'));
    }

    public function store(Halaman $req)
    {
        try {
            DB::beginTransaction();
            // $slug = $this->unique_slug(Str::slug($req->judul));
            $slug = Str::slug($req->judul);
            AM::create([
                'judul' => $req->judul,
                'slug' => $slug,
                'konten' => $req->konten,
                'route' => URL::route('halaman', ['slug' => $slug]),
                'thumbnail' => $req->has('thumbnail') ? $req->thumbnail->store('halaman', 'public') : null,
                'user_id' => Auth::id()
            ]);
            DB::commit();
            Alert::toast('Berhasil Simpan Data', 'success');
            return redirect()->route('halaman.semua-halaman');
        } catch (\Throwable $th) {
            DB::rollBack();
            Alert::toast('Gagal Simpan Data', 'error');
            return redirect()->route('halaman.semua-halaman');
        }
    }

    public function unique_slug($slug)
    {
        $isExist = true;
        $i = 1;
        do {
            if ($this->check_slug($slug) == 0) {
                $isExist = false;
            } else {
                $slug = $slug . '-' . $i;
            }
            $i++;
        } while ($isExist);
        return $slug;
    }

    public function check_slug($slug)
    {
        return AM::where('slug', $slug)->count();
    }

    public function edit($id)
    {
        $bc = ['title' => 'Halaman', 'subtitle' => 'Edit Halaman'];
        $data = AM::findOrFail($id);
        return view('admin.halaman.edit', compact('bc', 'data'));
    }

    public function update(Halaman $req, $id)
    {
        try {
            DB::beginTransaction();
            // $slug = $this->unique_slug(Str::slug($req->judul));
            $slug = Str::slug($req->judul);
            $data = [
                'judul' => $req->judul,
                'slug' => $slug,
                'konten' => $req->konten,
                'route' => URL::route('halaman', ['slug' => $slug]),
            ];
            if ($req->has('thumbnail')) {
                $data['thumbnail'] = $req->thumbnail->store('halaman', 'public');
            }
            AM::findOrFail($id)->update($data);
            DB::commit();
            Alert::toast('Berhasil Simpan Data', 'success');
            return redirect()->route('halaman.semua-halaman');
        } catch (\Throwable $th) {
            DB::rollBack();
            Alert::toast('Gagal Simpan Data', 'error');
            return redirect()->route('halaman.semua-halaman');
        }
    }

    public function destroy($id)
    {
        try {
            AM::findOrFail($id)->delete();
            Alert::toast('Berhasil Hapus Data', 'success');
            return redirect()->route('halaman.semua-halaman');
        } catch (\Throwable $th) {
            Alert::toast('Gagal Hapus Data', 'error');
            return redirect()->route('halaman.semua-halaman');
        }
    }

    public function sampah()
    {
        $bc = ['title' => 'Halaman', 'subtitle' => 'Sampah'];
        $data = AM::onlyTrashed()->paginate(10);
        return view('admin.halaman.sampah', compact('bc', 'data'));
    }

    public function restore($id)
    {
        try{
            AM::onlyTrashed()->findOrFail($id)->restore();
            Alert::toast('Berhasil Restore Data', 'success');
            return redirect()->route('halaman.semua-halaman');
        }catch(\Throwable $th){
            Alert::toast('Gagal Restore Data', 'error');
            return redirect()->route('halaman.sampah');
        }
        
    }

    public function force_delete($id)
    {
        try{
            $lama = AM::onlyTrashed()->findOrFail($id);
            if($lama->thumbnail){
                hapus_file($lama->thumbnail);
            }
            $lama->forceDelete();
            Alert::toast('Berhasil Hapus Data', 'success');
            return redirect()->route('halaman.semua-halaman');
        }catch(\Throwable $th){
            Alert::toast('Gagal Hapus Data', 'error');
            return redirect()->route('halaman.sampah');
        }
    }
}
