<?php

namespace App\Http\Controllers;

use App\Models\AlbumKegiatan;
use App\Models\FotoKegiatan;
use Illuminate\Http\Request;
use App\Models\Halaman;
use App\Models\KategoriPost;
use App\Models\Menu;
use App\Models\Post;
use App\Models\Pengumuman;
use App\Models\Unduhan;
use Illuminate\Support\Facades\Storage;
use Spatie\Sitemap\Sitemap;

class GuestController extends Controller
{

    public function beranda()
    {
        return view('guest.beranda');
    }

    public function halaman($slug)
    {
        try {
            $data = Halaman::where('slug', $slug)->with(['to_user' => function ($user) {
                $user->select('id', 'name');
            }])->first();
            if ($data) {
                return view('guest.halaman', compact('data'));
            } else {
                abort(404);
            }
        } catch (\Throwable $th) {
            abort(404);
        }
    }

    public function post($slug)
    {
        try {
            $data = Post::where('slug', $slug)->with(['to_kategori' => function ($kategori) {
                $kategori->select('id', 'nama', 'slug');
            }, 'to_user' => function ($user) {
                $user->select('id', 'name');
            }])->first();
            if ($data) {
                return view('guest.post', compact('data'));
            } else {
                abort(404);
            }
        } catch (\Throwable $th) {
            abort(404);
        }
    }

    public function kategori($slug = null)
    {
        try {
            if ($slug == null) {
                $data = KategoriPost::withCount(['to_post' => function ($post) {
                    $post->where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->orderBy('tanggal_publish', 'desc');
                }])->orderBy('nama')->get();
                return view('guest.semua-kategori', compact('data'));
            } else {
                $data = KategoriPost::where('slug', $slug)->first();
                if ($data) {
                    $kategori = Post::where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->where('kategori_id', $data->id)->with(['to_kategori' => function ($kategori) {
                        $kategori->select('id', 'nama', 'slug');
                    }, 'to_user' => function ($user) {
                        $user->select('id', 'name');
                    }])->orderBy('tanggal_publish', 'desc')->paginate(4);
                    return view('guest.kategori', compact('kategori', 'data'));
                } else {
                    abort(404);
                }
            }
        } catch (\Throwable $th) {
            abort(404);
        }
    }

    public function pengumuman($slug = null)
    {
        try {
            if ($slug == null) {
                $data = Pengumuman::with(['to_user' => function ($user) {
                    $user->select('id', 'name');
                }])->where('is_active', 1)->orderBy('tanggal_publish', 'desc')->paginate(6);
                return view('guest.semua-pengumuman', compact('data'));
            } else {
                $data = Pengumuman::where('slug', $slug)->where('is_active', 1)->with(['to_user' => function ($user) {
                    $user->select('id', 'name');
                }])->first();
                if ($data) {
                    return view('guest.pengumuman', compact('data'));
                } else {
                    abort(404);
                }
            }
        } catch (\Throwable $th) {
            abort(404);
        }
    }

    public function unduhan()
    {
        $data = Unduhan::where('is_active', 1)->paginate(10);
        return view('guest.unduhan', compact('data'));
    }

    public function unduh($folder, $file)
    {
        try {
            $data = Unduhan::where('file', $folder . '/' . $file)->first();
            if ($data) {
                $ext = pathinfo(storage_path($data->file), PATHINFO_EXTENSION);
                $nama = $data->judul . '.' . $ext;
                return response()->download(Storage::disk('public')->path($data->file), $nama);
            } else {
                abort(404);
            }
        } catch (\Throwable $th) {
            abort(404);
        }
    }

    public function album_kegiatan($slug = null)
    {
        try {
            if ($slug == null) {
                $data = AlbumKegiatan::with('to_foto_kegiatan_thumbnail')->where('is_active', 1)->paginate(10);
                return view('guest.album-kegiatan', compact('data'));
            } else {
                abort(404);
            }
        } catch (\Throwable $th) {
            abort(404);
        }
    }

    public function foto_kegiatan($slug)
    {
        try {
            if ($slug == null) {
                abort(404);
            } else {
                $data = AlbumKegiatan::where('slug', $slug)->where('is_active', 1)->first();
                if ($data) {
                    $foto = FotoKegiatan::where('album_id', $data->id)->get();
                    return view('guest.foto-kegiatan', compact('data', 'foto'));
                } else {
                    abort(404);
                }
            }
        } catch (\Throwable $th) {
            abort(404);
        }
        return view('guest.foto-kegiatan');
    }

    public function cari(Request $req)
    {
        try {
            $data = Post::where('judul', 'like', '%' . $req->q . '%')->where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->orderBy('tanggal_publish', 'desc')->with(['to_kategori' => function ($kategori) {
                $kategori->select('id', 'nama', 'slug');
            }, 'to_user' => function ($user) {
                $user->select('id', 'name');
            }])->paginate(4)->withQueryString();
            $key = urlencode($req->q);
            return view('guest.pencarian', compact('data', 'key'));
        } catch (\Throwable $th) {
            abort(404);
        }
    }

    public function sitemap()
    {
        $posts = Post::where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->latest()->first();
        $pengumuman = Pengumuman::where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->latest()->first();
        $menu = Menu::latest()->first();
        return response()->view('sitemap.sitemap', compact('posts', 'pengumuman', 'menu'))->header('Content-Type', 'text/xml');
    }

    public function sitemap_menu()
    {
        $menu = Menu::all();
        return response()->view('sitemap.sitemap-menu', compact('menu'))->header('Content-Type', 'text/xml');
    }

    public function sitemap_post()
    {
        $posts = Post::where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->orderBy('tanggal_publish', 'desc')->get();
        return response()->view('sitemap.sitemap-post', compact('posts'))->header('Content-Type', 'text/xml');
    }

    public function sitemap_kategori()
    {
        $kategori = KategoriPost::with(['to_post' => function($q){
            $q->latest()->first();
        }])->get();
        return response()->view('sitemap.sitemap-kategori', compact('kategori'))->header('Content-Type', 'text/xml');
    }

    public function sitemap_pengumuman()
    {
        $pengumuman = Pengumuman::where('is_active', 1)->where('tanggal_publish', '<=', date('Y-m-d'))->get();
        return response()->view('sitemap.sitemap-pengumuman', compact('pengumuman'))->header('Content-Type', 'text/xml');
    }
}
