<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;

function tanggal_indo($tanggal)
{
    return Carbon::parse($tanggal)->isoFormat('DD MMMM YYYY');
}

function tanggal_indo_full($tanggal)
{
    return Carbon::parse($tanggal)->isoFormat('DD MMMM YYYY, HH:mm');
}

function hapus_file($path):void
{
    Storage::disk('public')->delete($path);
}

function setEnv($key, $value)
{
	file_put_contents(app()->environmentFilePath(), str_replace(
		$key . '=' . env($value),
		$key . '=' . $value,
		file_get_contents(app()->environmentFilePath())
	));
}

