<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\InstagramAccessToken;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class RefreshToken extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'instagram:refresh-token';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Refresh Token Instagram';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        try {
            $profil = InstagramAccessToken::all();
            foreach ($profil as $pr) {
                $req = Http::accept('application/json')->get('https://graph.instagram.com/refresh_access_token', [
                    'grant_type' => 'ig_refresh_token',
                    'access_token' => $pr->access_token,
                ]);

                $response = $req->json();
                $pr->update([
                    'access_token' => $response['access_token'],
                    'token_type' => $response['token_type'],
                    'expires_in' => $response['expires_in']
                ]);
            }
            Log::info('Berhasil Update Token');
            $this->info('Berhasil Update Token');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            $this->error('Gagal Update Token');
        }
    }
}
